#define TEST

#define MIN_DUMMY_CODE_SIZE  4096
#define MAX_DUMMY_CODE_SIZE  262144

#define MAX_PROLOGUE_INSTRUCTIONS  64

#define MAX_FUNCTION_NAME    32
#define MAX_MODULE_NAME      16

#define IMAGE_BASE           0x400000;
#define SECTION_ALIGNMENT    4096
#define FILE_ALIGNMENT       512

#define PERCENT_DATA_SIZE    25
#define MIN_DATA_SIZE        1536
#define PERCENT_RDATA_SIZE   10
#define MIN_RDATA_SIZE       512
#define MIN_BSS_SIZE         3072

#define MAX_SECTIONS       7
#define SECTION_DATA       1
#define SECTION_RDATA      2
#define SECTION_BSS        3
#define SECTION_IMPORT     4
#define SECTION_RELOC      5
#define SECTION_RESOURCE   6

#pragma pack(1);

typedef struct TagINSTRUCTION { // structure is used to keep instruction
  BYTE   Sz;         // size of instruction
  BYTE   ModFlag;    // modification flag
  BYTE   Instr[16];  // instruction
} INSTRUCTION;

typedef struct TagINSTRUCTION2 { //contains additional data for code generation
  INSTRUCTION  Instr;     // standard data
  BYTE         Type;      // type of instruction
  BYTE         Value;     // aux. value
  DWORD        IP;        // instruction pointer where instr. will be placed
} INSTRUCTION2;

// instruction types
#define IT_ORD       0   // ordinary instruction, no additional value
#define IT_JUMP      1   // Value contains 0-based index of destination
#define IT_CALL      2   // Value contains 0-based entry index in imp.table
#define IT_CBEGIN    3   // Value contains offset in the instruction
                         // where Code_Begin offset of loader must be placed
#define IT_XOR       4   // Value contains  0-based xor value idx (0-a,1-b,..)
                         // which instruction must contain in low nibble
                         // and offset of immediate data in the instruction
                         // in high nibble
#define IT_CONST     5   // instruction contains 08088405 constant xored with
                         // value a, value is index of imm data inside
                         // instruction
#define IT_CSIZE     6   // instruction contains number size of encrypted data
                         // xored with value b

typedef struct TagIMPORTENTRY { // import table element
  char  Function[ MAX_FUNCTION_NAME ];
  char  Module[ MAX_MODULE_NAME ];
} IMPORTENTRY;

typedef struct TagLDRIMPORTENTRY { // loader's import table entry
  BYTE   JumpOpcode;
  DWORD  RelativeAddress;
  IMPORTENTRY  Destination;
} LDRIMPORTENTRY;

#pragma pack();

typedef struct TagIMPORTS {  // import table
  char**  FuncNames;
  DWORD   FuncCount;
  char    ModuleName[ MAX_MODULE_NAME ];
} IMPORTS;

typedef struct TagEXEDEF {
  BYTE*  Src;                     // source file
  DWORD  SrcSize;
  HANDLE  HOut;                   // output file;
  DWORD   PEHdrOffset;            // PE signature offset in output file
  IMAGE_FILE_HEADER  FileHdr;     // PE header for output file
  IMAGE_OPTIONAL_HEADER  OptHdr;  // optional header for output file
  IMAGE_SECTION_HEADER  Sections[ MAX_SECTIONS ];
  DWORD  oSrcFileHdr;             // source file header offset
  FILETIME KernelTime;
  BYTE*  Code;                    // buffer for generated prologue code
  DWORD  CodeSize;
  DWORD  EntryPoint;
  DWORD  P_IP[ MAX_PROLOGUE_INSTRUCTIONS ]; // instruction pointer for each prologue instruction
  DWORD  DummyCodeSize;           // required size for prologue code
  DWORD  Keys[4];                 // xor values
  DWORD  IATOffset;
  DWORD  EncryptedCodeSize;
  IMAGE_SECTION_HEADER*  SrcRscr; // ptr to rsrc section header of source file
  DWORD  SectionOrder[ MAX_SECTIONS ];  // code section is always first
  IMAGE_IMPORT_MODULE_DIRECTORY* WinsockImpDirEntry; // in source file
  DWORD  ImportModuleOrder[ MAX_IMPORT_MODULES ]; // 1-based indexes in Imports, 0 for winsock
  DWORD  ImportModuleCount;
  DWORD  ImportFunctionCount[ MAX_IMPORT_MODULES ];
  DWORD* ImportFunctionIndex[ MAX_IMPORT_MODULES ]
  DWORD  TotalImports;
  BYTE*  IATBuf;
  BOOL   SplitNameAddr;
  DWORD  IdataSectionIdx;
  DWORD  IdataSize;
  BYTE*  Idata;                   // import data section
  BYTE*  RelocBuf;
  DWORD  RelocBlockStart;
  DWORD  RelocBufIdx;
  DWORD  RelocLastVA;

  // subsystem-dependent

  IMPORTS* Imports;               // tables with import function names
  DWORD    ImportsSize;
  BYTE*    LdrCode;               // loader's code
  DWORD    LdrCodeSize;
  DWORD    LdrImportsOffset;
  DWORD    LdrImportsSize;        // number of entries in import table
  INSTRUCTION2* Prologue;
  DWORD    PrologueSize;
  IMPORTENTRY* PrologueImports;
  DWORD    PrologueImportsSize;
} EXEDEF;

extern INSTRUCTION  ITable[];
extern DWORD        ITableSize, ITableI32Count, ITableOftCount;
extern INSTRUCTION2 PTable[];
extern DWORD        PTableSize;
extern IMPORTENTRY  PImpTable[];
extern DWORD        LoaderCodeSize, LoaderITSize, LoaderITOffset;
extern BYTE         LoaderCode[];


#ifdef TEST

#  define Dbg( a ) DbgOut( a )
#  define Dbg1( a, b ) DbgOut( a, b )
#  define Dbg2( a, b, c ) DbgOut( a, b, c )
#  define Dbg3( a, b, c, d ) DbgOut( a, b, c, d )
#  define Dbg4( a, b, c, d, e ) DbgOut( a, b, c, d, e )
#  define Dbg5( a, b, c, d, e, f ) DbgOut( a, b, c, d, e, f )
#  define Dbg6( a, b, c, d, e, f, g ) DbgOut( a, b, c, d, e, f, g )
#  define Dbg7( a, b, c, d, e, f, g, h ) DbgOut( a, b, c, d, e, f, g, h )
#  define Dbg8( a, b, c, d, e, f, g, h, i ) DbgOut( a, b, c, d, e, f, g, h, i )
#  define Dbg9( a, b, c, d, e, f, g, h, i, j ) DbgOut( a, b, c, d, e, f, g, h, i, j )

#else

#  define Dbg( a )
#  define Dbg1( a, b )
#  define Dbg2( a, b, c )
#  define Dbg3( a, b, c, d )
#  define Dbg4( a, b, c, d, e )
#  define Dbg5( a, b, c, d, e, f )
#  define Dbg6( a, b, c, d, e, f, g )
#  define Dbg7( a, b, c, d, e, f, g, h )
#  define Dbg8( a, b, c, d, e, f, g, h, i )
#  define Dbg9( a, b, c, d, e, f, g, h, i, j )

#endif
